/*************************************Nand Communication Using I/O's And ST7 Library************************************************/
/**********************************************************************************************************************************/

/************************************************Documentation*********************************************************************/
/*General Purpose - Contains source code for all the functions of NAND (x8) Communication using I/O's 
									Ports used for communication are Port A and Port B 
									Port A is used for enviornment setting 
									Port B is used for Data,Address and command transfer */
/**********************************************************************************************************************************/

#include "ST7lib_config.h"                            /* Selection of device */
#include "IO_hr.h"                                    /* IO registers bit definitions */
#include "IO.h"                                       /* Prototype definitions of IO library functions */
#include "nand_io.h"

/***************************************global varaibles******************************************/
unsigned char data_read[512];
unsigned char manufacturer_code;
unsigned char	device_code;
unsigned char	Timeoutcount2 = 0;


/*--------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Nand_write
INPUT        : pointer to the data,colum number,page number,block number, number of bytes to be written
OUTPUT       : None	       
DESCRIPTION  : writing of page of NAND starting from the selected colum location 
COMMENTS     : When using the I/O mode of writing then DTC should not be enabled
---------------------------------------------------------------------------------------------------------------------------------*/

void nand_write(unsigned char *data,unsigned char colum_add,unsigned char page_add,unsigned int block_add,unsigned char n)
{
  unsigned char statreg,l=0;
  
	nand_io_init();					                                 	/* nand io initialization*/
 
	command(nand_area_A);                                      /*pointer setting to first/second half page*/
	command(nand_pageprogram);                               /*pointer setting to page program mode*/
	address(colum_add,page_add,block_add);                    /*address of the memory location in NAND*/
				
/************************************************writing into the NAND*****************************************************************************/
	nand_io_init();
	IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_LOW);                         /*Chip is selected*/
  PBDR = 0xff;																						/*configure data lines in output mode*/	
  while(l < n) 	                                                     /* page writing for n bytes*/
			{
			  PBDR = *data;
        writepulses();
				data++;
				l++;
			}	
  		
	 command(nand_endpageprogram);                                  /*page programe confirmation command*/
	
	 Timeoutcount2 = 0;
	do
	{
		statreg = statusreg_read();                                     /*reading status register*/
	}while((User_Timeout_Function2()) && ((statreg & 0x40)!= 0x40));  /*checking for completion of page write from buffer*/	
	 
	IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_HIGH);                     /*generating the chip disable signal*/
 
}
/***************************************************************end of nand write********************************************************************/
/****************************************************************************************************************************************************/

/*---------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : nand_read
INPUT        : number of bytes to be read,page number,block number
OUTPUT       : Data is read from the NAND and is stored in an arra, data_read[]      
DESCRIPTION  : reading of selected page of NAND starting from 0th colum location 
COMMENTS     : When using the I/O mode of writing then DTC should not be enabled
---------------------------------------------------------------------------------------------------------------------------------------------------*/
 
void nand_read (unsigned char n,unsigned char page_read, unsigned int block_read)
{
  unsigned char statreg = 0,counter = 0;
  Timeoutcount2 = 0;
	nand_io_init();						                                                   /* #CE high and #WP high*/
	
	command(nand_area_A);
	address(0x00,page_read,block_read);
	 
  do
		{
			statreg = statusreg_read();                                             /*reading status register*/
		}while((User_Timeout_Function2()) && ((statreg & 0x40)!= 0x40));          /*checking for completion of page write from buffer*/
	
 command(nand_area_A);                                                       /*returning the pointer to the first half page*/
 nand_io_init();
	
	PBDDR=0x00;																		/*configure PORT B in input mode*/
	IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_LOW);  //CE

	while(counter < n) 
		{
			readpulses();
			data_read[counter] = PBDR;
			counter++;
		}	
				
IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_HIGH);    /*generating the chip disable signal*/

}

/************************************************************end of nand read*************************************************************************************/
/*****************************************************************************************************************************************************************/
 /*---------------------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Signature
INPUT        : None
OUTPUT       : manufacturer code abd device code	       
DESCRIPTION  : reading the manufacturer code and device code of NAND
COMMENTS     : None
-------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
 void signature (void)
				{
					//writeprotect_disable();
					nand_io_init();
          command(nand_read_electsign);
					IO_Write (IO_PORT_A,(IO_PIN_2 | IO_PIN_3),IO_DATA_HIGH);          /*address configuration*/
					IO_Write (IO_PORT_A,IO_PIN_0,IO_DATA_LOW);                        /*address configuration*/
					IO_ByteWrite (IO_PORT_B,0x00);                                    /*address write*/
					writepulses();                                                    /*generating write pulse*/
					IO_Input (IO_FLOATING,IO_PORT_B,(IO_PIN_0 |( IO_PIN_1 |( IO_PIN_2 | (IO_PIN_3 | (IO_PIN_4 | (IO_PIN_5 | (IO_PIN_6 | IO_PIN_7)))))))); /*configure data lines in input mode*/
					IO_Write (IO_PORT_A,IO_PIN_1,IO_DATA_HIGH);
					IO_Write (IO_PORT_A,(IO_PIN_0 | IO_PIN_2),IO_DATA_LOW);	
					readpulses();																                      	/*generating read pulse*/
					manufacturer_code = IO_Read (IO_PORT_B);
					readpulses();																                       	/*generating read pulse*/
					device_code =  IO_Read (IO_PORT_B);
				}
				
/************************************************************end of signature function*****************************************************************************/				

/*---------------------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : writeprotect_enable
INPUT        : None
OUTPUT       : None.	       
DESCRIPTION  : generating the write protection signal.
COMMENTS     : after this function device cant be read or erased. 
---------------------------------------------------------------------------------------------------------------------------------------------------------------*/
void writeprotect_enable(void)
{
  IO_Output (IO_OPEN_DRAIN,IO_PORT_A,IO_PIN_7);	
  IO_Write (IO_PORT_A,IO_PIN_7,IO_DATA_LOW); // #WP enabled
}
/********************************************************end of writeprotect_enablefunction*********************************************************************/				

/*---------------------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : writeprotect_disable
INPUT        : None
OUTPUT       : None.	       
DESCRIPTION  : disabling the write protection signal.
COMMENTS     : after this function device can be read or erased. 
---------------------------------------------------------------------------------------------------------------------------------------------------------------*/

void writeprotect_disable(void)
{
  IO_Output (IO_OPEN_DRAIN,IO_PORT_A,IO_PIN_7);	
  IO_Write (IO_PORT_A,IO_PIN_7,IO_DATA_HIGH); // #WP disabled
}

/********************************************************end of writeprotect_disable function*********************************************************************/				
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Command
INPUT        : command byte
OUTPUT       : None.	       
DESCRIPTION  : Setting the command for nand operations
COMMENTS     : None
---------------------------------------------------------------------------------------------------------------------------------------------------------------*/

void command (unsigned char cmd)
{
	IO_Write (IO_PORT_A,IO_PIN_2,IO_DATA_LOW);		 /*ALE*/
	IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_LOW);    /*generating the chip enable signal*/
	
	IO_Write (IO_PORT_A,IO_PIN_0,IO_DATA_HIGH);		/*CLE*/ 
	
	IO_Output (IO_PUSH_PULL,IO_PORT_B,(IO_PIN_0 |( IO_PIN_1 |( IO_PIN_2 | (IO_PIN_3 | (IO_PIN_4 | (IO_PIN_5 | (IO_PIN_6 | IO_PIN_7))))))));
	
	
	IO_ByteWrite (IO_PORT_B,cmd);
	writepulses(); 												      	/*generating write pulse*/
	                                            
	IO_Write (IO_PORT_A,IO_PIN_0,IO_DATA_LOW);		/*CLE*/
	
}

/********************************************************end of command function*********************************************************************/				

/*---------------------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Address
INPUT        : Colum Number,Page Number,Block Number.
OUTPUT       : None.	       
DESCRIPTION  : Setting the address for accessing the specific location in NAND 
COMMENTS     : forth address byte is used only for NAND above 256Mb (for 512Mb and 1Gb)
---------------------------------------------------------------------------------------------------------------------------------------------------------------*/


void address (unsigned char colum,unsigned char page,unsigned int block)
{
	unsigned char blk;
	IO_Output (IO_PUSH_PULL,IO_PORT_B,(IO_PIN_0 |( IO_PIN_1 |( IO_PIN_2 | (IO_PIN_3 | (IO_PIN_4 | (IO_PIN_5 | (IO_PIN_6 | IO_PIN_7))))))));
	blk = block;
	blk = blk << 5;
	page = page | blk;
	block = block >> 3;
	
	nand_io_init();
	
	IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_LOW);      /*CE*/
	IO_Write (IO_PORT_A,IO_PIN_2,IO_DATA_HIGH);     /*ALE*/
	
 
	IO_ByteWrite (IO_PORT_B,colum);
	writepulses();																 /*generating second write pulse*/
	IO_ByteWrite (IO_PORT_B,page);
	writepulses();								 								/*generating second write pulse*/
	IO_ByteWrite (IO_PORT_B,block);
	writepulses();																/*generating third write pulse*/    
	IO_ByteWrite (IO_PORT_B,0x00);				/* ONLY FOR NAND ABOVE 256Mb*/
	writepulses();				/*generating forth write pulse, it is used only for NAND above 256Mb*/		
   
	IO_Write (IO_PORT_A,IO_PIN_2,IO_DATA_LOW);		/*ALE goes LOW*/

}

/********************************************************end of address function*********************************************************************/				


 /*----------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Statusreg_read
INPUT        : None
OUTPUT       : Status of bits in status register of Nand	       
DESCRIPTION  : It checks for error condition through the bits in status register
COMMENTS     : None
------------------------------------------------------------------------------------------------------------------------------------------*/
	

unsigned char statusreg_read(void)
{
	unsigned char sr = 0;
	
	nand_io_init();
	command(nand_readstatusreg );               /*status register read command*/
 	IO_Input (IO_FLOATING,IO_PORT_B,(IO_PIN_0 |( IO_PIN_1 |( IO_PIN_2 | (IO_PIN_3 | (IO_PIN_4 | (IO_PIN_5 | (IO_PIN_6 | IO_PIN_7)))))))); /*configure data lines in input mode*/
	IO_Write (IO_PORT_A,IO_PIN_1,IO_DATA_HIGH); //WE
	IO_Write (IO_PORT_A,(IO_PIN_0 | IO_PIN_2),IO_DATA_LOW); //ALE,CLE
	readpulses();
	sr = IO_Read (IO_PORT_B); /*reading status register*/
	return(sr);
}

/********************************************************end of status register read function*********************************************************************/				
/*------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Readpulses
INPUT        : None
OUTPUT       : None	       
DESCRIPTION  : configuring the I/O port to generate the read pulses for data reading from NAND
COMMENTS     : None
---------------------------------------------------------------------------------------------------------------------------------------------------*/	

void readpulses (void)
{
	IO_Write (IO_PORT_A,IO_PIN_3,IO_DATA_LOW);
	IO_Write (IO_PORT_A,IO_PIN_3,IO_DATA_HIGH);	/*generating read pulse*/
	}

/********************************************************end of read pulses function*********************************************************************/				  
/*----------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Writepulses
INPUT        : None
OUTPUT       : None	       
DESCRIPTION  : configuring the I/O port to generate the write pulses for data writing in NAND
COMMENTS     : None
-----------------------------------------------------------------------------------------------------------------------------------------------------*/	
  
void writepulses (void)
{
	IO_Write (IO_PORT_A,IO_PIN_1,IO_DATA_LOW); /*generating write pulse*/
	IO_Write (IO_PORT_A,IO_PIN_1,IO_DATA_HIGH);
}
/********************************************************end of write pulses function*********************************************************************/				

/*-----------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : Block_erase
INPUT        : block address to be erased
OUTPUT       : None	       
DESCRIPTION  : configuring the I/O port to generate the write pulses for data writing in NAND
COMMENTS     : Fourth byte is used for 512Mb and 1Gb Nand
------------------------------------------------------------------------------------------------------------------------------------------------------*/	
void block_erase(unsigned int block)
{
 	unsigned char statreg=0x00;
	unsigned char blk,page = 0; 
	Timeoutcount2 = 0;
 
	blk = block;
	blk = blk << 5; 
	page = page | blk; 
	block = block >> 3;

  nand_io_init();
	                                                                  
	command(nand_blockerase);	                                         /*Command for Block erase*/
	IO_Write (IO_PORT_A,IO_PIN_2,IO_DATA_HIGH);                          /*ALE*/
 	
	IO_Output (IO_PUSH_PULL,IO_PORT_B,(IO_PIN_0 |( IO_PIN_1 |( IO_PIN_2 | (IO_PIN_3 | (IO_PIN_4 | (IO_PIN_5 | (IO_PIN_6 | IO_PIN_7)))))))); /*address sending of the block*/
	IO_ByteWrite (IO_PORT_B,page); 
	writepulses();
	IO_ByteWrite (IO_PORT_B,block); 
	writepulses();
	IO_ByteWrite (IO_PORT_B,0x00); 
	writepulses();
	command(nand_confirmerase );                                       /* block Erase confirmation command*/
		do
		{
			statreg = statusreg_read();                                     /*reading status register*/
		}while((User_Timeout_Function2()) && ((statreg & 0x40)!= 0x40)); /*checking for completion of page write from buffer*/
					
			 				
}

/*----------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : bad_block_decleration
INPUT        : block address to be erased
OUTPUT       : None	       
DESCRIPTION  : used tomark the block as bad block
COMMENTS     : None
----------------------------------------------------------------------------------------------------------------------------------------------------*/	

void bad_block_decleration(unsigned int block_add)
{
  unsigned char statreg;
  unsigned char m = 0;
	Timeoutcount2 = 0;
	
	  nand_io_init();
	  IO_Output (IO_PUSH_PULL,IO_PORT_B,(IO_PIN_0 |( IO_PIN_1 |( IO_PIN_2 | (IO_PIN_3 | (IO_PIN_4 | (IO_PIN_5 | (IO_PIN_6 | IO_PIN_7))))))));/*configure data lines in output mode*/
		command(nand_area_C);                /*pointer setting to section c of nand*/
		command(nand_pageprogram);          /*pointer setting to page program mode*/
		address(0x00,0x00,block_add);         /*address of the memory location in NAND*/
	  	
		while(m < 10) 	
  	 {
   		 IO_ByteWrite (IO_PORT_B,0x00);
				writepulses();
				m++;
			}					
			 	
    command(nand_endpageprogram);     /*page programe confirmation command*/
		do
		{
			statreg = statusreg_read();     /*reading status register*/
		}while((User_Timeout_Function2()) && ((statreg & 0x40)!= 0x40)); /*checking for completion of page write from buffer*/
	
    IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_HIGH);  /*CE disable*/

}
/*****************************************************end of bad block decleration function***********************************************************************/
/*****************************************************************************************************************************************************************/
/*----------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : nand_io_init
INPUT        : None
OUTPUT       : None	       
DESCRIPTION  : configuring the I/O port to generate the default state of different communication lines of NAND
COMMENTS     : None 
----------------------------------------------------------------------------------------------------------------------------------------------------*/	
void nand_io_init(void)
{
  writeprotect_disable();
	IO_Output (IO_PUSH_PULL,IO_PORT_A,(IO_PIN_0 |( IO_PIN_1 |( IO_PIN_2 | IO_PIN_3))));
	IO_Output (IO_OPEN_DRAIN,IO_PORT_E,IO_PIN_0); // CE of NAND
	IO_Write (IO_PORT_E,IO_PIN_0,IO_DATA_HIGH);   // CE DISABLE 
  IO_Write (IO_PORT_A,IO_PIN_0,IO_DATA_LOW);    // CLE
	IO_Write (IO_PORT_A,IO_PIN_1,IO_DATA_HIGH);   // #WE
	IO_Write (IO_PORT_A,IO_PIN_2,IO_DATA_LOW);    //ALE
	IO_Write (IO_PORT_A,IO_PIN_3,IO_DATA_HIGH);   //#RD
}
/*************************************************************end of nand_io_init function**********************************************************************/
/***************************************************************************************************************************************************************/

/*----------------------------------------------------------------------------------------------------------------------------------------------------
ROUTINE NAME : User_Timeout_Function2
INPUT        : None
OUTPUT       : True or False based on thime elapsed	       
DESCRIPTION  : this function returns a boolian signal of true or false
COMMENTS     : None 
----------------------------------------------------------------------------------------------------------------------------------------------------*/	

BOOL User_Timeout_Function2(void)
{
	while(Timeoutcount2 < 100)
	{
		Timeoutcount2++ ;
		return (TRUE); /* Time-out not elapsed */
	}
		return (FALSE) ; /* Time-out elapsed */
}

/*************************************************************end of User_Timeout_Function2 function**********************************************************************/
/***************************************************************************************************************************************************************/

